/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.WardenModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.warden.Warden;

public class WardenEmissiveLayer<T extends Warden, M extends WardenModel<T>>
extends RenderLayer<T, M> {
    private final ResourceLocation texture;
    private final AlphaFunction<T> alphaFunction;
    private final DrawSelector<T, M> drawSelector;

    public WardenEmissiveLayer(RenderLayerParent<T, M> p_234885_, ResourceLocation p_234886_, AlphaFunction<T> p_234887_, DrawSelector<T, M> p_234888_) {
        super(p_234885_);
        this.texture = p_234886_;
        this.alphaFunction = p_234887_;
        this.drawSelector = p_234888_;
    }

    @Override
    public void render(PoseStack p_234902_, MultiBufferSource p_234903_, int p_234904_, T p_234905_, float p_234906_, float p_234907_, float p_234908_, float p_234909_, float p_234910_, float p_234911_) {
        if (((Entity)p_234905_).isInvisible()) {
            return;
        }
        this.onlyDrawSelectedParts();
        VertexConsumer $$10 = p_234903_.getBuffer(RenderType.entityTranslucentEmissive(this.texture));
        float $$11 = this.alphaFunction.apply(p_234905_, p_234908_, p_234909_);
        int $$12 = FastColor.ARGB32.color(Mth.floor($$11 * 255.0f), 255, 255, 255);
        ((WardenModel)this.getParentModel()).renderToBuffer(p_234902_, $$10, p_234904_, LivingEntityRenderer.getOverlayCoords(p_234905_, 0.0f), $$12);
        this.resetDrawForAllParts();
    }

    private void onlyDrawSelectedParts() {
        List<ModelPart> $$0 = this.drawSelector.getPartsToDraw((WardenModel)this.getParentModel());
        ((WardenModel)this.getParentModel()).root().getAllParts().forEach(p_234918_ -> {
            p_234918_.skipDraw = true;
        });
        $$0.forEach(p_234916_ -> {
            p_234916_.skipDraw = false;
        });
    }

    private void resetDrawForAllParts() {
        ((WardenModel)this.getParentModel()).root().getAllParts().forEach(p_234913_ -> {
            p_234913_.skipDraw = false;
        });
    }

    public static interface AlphaFunction<T extends Warden> {
        public float apply(T var1, float var2, float var3);
    }

    public static interface DrawSelector<T extends Warden, M extends EntityModel<T>> {
        public List<ModelPart> getPartsToDraw(M var1);
    }
}

